<?php
    if ($method == "GET") {
        if (!$authorized) send403();

        if ($subdir) {
            try {
                $request = PTORequest::findRequest($user, $subdir);

                $resp = array("success" => true, "data" => $request->getSanitizedData());
            } catch (Exception $err) {
                $resp["message"] = $err->getMessage();
            }

            finish();
        }

        if (isset($params["workers"]) && $params["workers"]) {
            if (!$user->is_supervisor) send403($resp["message"] = "User is not a supervisor");
            $workers = $user->getWorkers();
            if ($user->supervisor_id != $user->id) array_unshift($workers, $user);

            $requests = array();
            foreach ($workers as $worker) {
                $reqs = PTORequest::getRequests($worker);
                if (count($reqs) > 0) foreach ($reqs as $req) {
                    array_push($requests, $req->getSanitizedData());
                }
            }

            finish($resp = array("success" => true, "data" => $requests));
        }

        try {
            $ptouser = $user;
            if ($subdir) {
                $ptouser = $uManager->findUser($subdir);
            }

            $requests = PTORequest::getRequests($ptouser);
            $sanitized = array();

            foreach($requests as $request) array_push($sanitized, $request->getSanitizedData());

            $resp = array("success" => true, "data" => $sanitized);
        } catch (Exception $err) {
            $resp["message"] = $err->getMessage();
        }
    }

    if ($method == "POST") {
        if (!$authorized) send403();

        if (!isset($params["date_start"]) || !isset($params["date_end"])) finish($resp["message"] = "Missing or invalid parameters");
        if (date($dtformat, strtotime($params["date_start"])) != $params["date_start"]) finish($resp["message"] = "Invalid date provided");
        if (date($dtformat, strtotime($params["date_end"])) != $params["date_end"]) finish($resp["message"] = "Invalid date provided");
        if (empty($params["paid"])){
            $params["paid"] = 0;
        }

        try {
            $resp = array("success" => true, "data" => PTORequest::createRequest($user, $params)->getSanitizedData());
        } catch (Exception $err) {
            $resp["message"] = $err->getMessage();
        }
    }

    if ($method == "PUT") {
        if (!$authorized) send403();

        if (!$subdir) finish($resp["message"] = "Missing or invalid request_id");

        try {
            $request = PTORequest::findRequest($user, $subdir);
            $edited = false;
            if (!$user->is_supervisor) finish($resp["message"] = "Not authorized to change own PTO request");
            if (!$user->is_supervisor) finish($resp["message"] = "Not authorized to change users PTO requests");

            if (isset($params["date_start"])) {
                if (date($dformat, strtotime($params["date_start"])) != $params["date_start"]) finish($resp["message"] = "Invalid date provided");
                $request->setStart($params["date_start"]);
                $edited = true;
            }
            if (isset($params["date_end"])) {
                if (date($dformat, strtotime($params["date_end"])) != $params["date_end"]) finish($resp["message"] = "Invalid date provided");
                $request->setEnd($params["date_end"]);
                $edited = true;
            }
            if (isset($params["notes"])) {
                $request->setNotes($params["notes"]);
                $edited = true;
            }
            if (isset($params["status"])) {
                $request->setReviewedBy($user->id);
                $request->setStatus($params["status"]);
                $edited = true;
            }

            if (isset($params["paid"])) {
                $request->setPaid($params["paid"]);
                $edited = true;
            }

            if ($edited) {
                $request = $request->apply();

                if ($request->status > 1) {
                    $query = http_build_query([
                        "start" => $request->date_start,
                        "end" => $request->date_end,
                        "name" => $request->user->full_name,
                        "department" => $request->user->department_name,
                        "notes" => $request->notes,
                        "supervisor" => $request->user->getSupervisor()->full_name,
                        "status" => $request->status_name
                    ]);

                    $url = "https://preferrederp1.com/app/timeoff/" . ($request->paid ? "renderPTO" : "renderUPTO") . ".php?" . $query;


                    $resource = curl_init();
                    curl_setopt($resource, CURLOPT_URL, $url);
                    curl_setopt($resource, CURLOPT_RETURNTRANSFER, true);
                    $pdf = curl_exec($resource);
                    curl_close($resource);


                    require_once '../../Mail/class.phpmailer.php';
                    include "../../functions.php";


                    $smtpUser="AKIATGFWMNLRBHQFWTOC";
                    $smtpPassword="BNW4PrbHUZ6bgWpbjfM8uKJFjy0Ccrb/MryTGf0Ir9KG";

                    $mail = new PHPMailer();
                    $mail->IsSMTP();
                    $mail->SMTPDebug  = 0;
                    $mail->Host       = "email-smtp.us-east-1.amazonaws.com";
                    $mail->Port       = 587;
                    $mail->SMTPSecure = 'tls';
                    $mail->SMTPAuth   = true;
                    $mail->Username   = $smtpUser;
                    $mail->Password   = $smtpPassword;

                    $email = "noreply@preferredmachinellc.com";
                    $mail->SetFrom($email,"Do Not Reply");
                    $mail->AddAddress($request->user->email,$user->full_name);
                    $mail->AddAddress($request->user->getSupervisor()->email,$user->getSupervisor()->full_name);

                    if ($request->status == 2) {
                        $mail->AddAddress("ap@preferredmachinellc.com","Accounting");
                    }

                    $mail->Subject = ($request->paid ? "Paid" : "Unpaid") . " Time Off Request";

                    $message = "Time off request has been updated! See attached PDF for details.";

                    $text=strip_tags($message);
                    $mail->AltBody = $text;
                    $mail->MsgHTML(str_replace("\n","<br>",$message));

                    $mail->addStringAttachment($pdf, "Time Off Request " . $request->id . ".pdf");

                    if (!$mail->Send()) {
                        finish($resp["message"] = "Failed to send email: " . $mail->ErrorInfo);
                    }
                }
            }

            $resp = array("success" => true, "data" => $request->getSanitizedData());
        } catch (Exception $err) {
            $resp["message"] = $err->getMessage();
        }
    }
?>