<?php
    if (!$authorized) send403();

    if ($method == "POST") {
        if ($subdir == false) finish($resp["message"] = "No recipient specified");
        if (!isset($params["message_text"])) finish($resp["message"] = "Missing or invalid parameters");

        try {
            $resp = array("success" => true, "data" => $user->messages->sendMessage($params["message_text"], $subdir));
        } catch (Exception $err) {
            $resp["message"] = $err->getMessage();
        }
    }

    if ($method == "GET") {

        if ($subdir != false) { //*if getting messages with a specific user
            $before = false;
            if (isset($params["before"])) {
                $before = $params["before"];
                if (date($dtformat, strtotime($before)) != $before) finish($resp["message"] = "Invalid date provided");
            }

            $after = false;
            if (isset($params["after"])) {
                $after = $params["after"];
                if (date($dtformat, strtotime($after)) != $after) finish($resp["message"] = "Invalid date provided");
            }

            try {
                if ($subdir == $user->id) finish($resp = array("success" => true, "data" => array()));
                $messages = $user->messages->getMessagesWith($subdir, $before, $after);
            } catch (Exception $err) {
                $resp["message"] = $err->getMessage();
            }

            finish($resp = array("success" => true, "data" => $messages));
        }

        try {
            $resp = array("success" => true, "data" => $user->messages->getRecentMessages());
        } catch (Exception $err) {
            $resp["message"] = $err->getMessage();
        }
    }
?>