<?php
//TODO Figure out how to import dtformat properly
    /**
     * For easy token management
     *
     * @author JoshuaA
     *
     */
    class Token {
        /**
         * The user that the Token belongs to
         * @var User
         */
        var $user;
        /**
         * The Tokens string value
         * @see User
         * @var string
         */
        var $token;
        /**
         * The Tokens ID
         * @var int
         */
        var $id;
        /**
         * When the Token will expire
         * @var string (YYYY-MM-DD HH:MM:SS)
         */
        var $valid_until;
        /**
         * Will be true if the token is deleted
         *
         * Used in case of being passed as a reference.
         * @var boolean
         */
        var $deleted;
        /**
         *
         * @param array<string, string|int> $token [
         *     "token_id" => int,
         *     "token" => string,
         *     "valid_until" => string (YYYY-MM-DD HH:MM:SS)
         * ]
         * @param User $user
         * @throws Exception "Given value is not an instance of User"
         * @return void
         */
        function __construct($token, $user) {
            if (!($user instanceof User)) throw new Exception("Given value is not an instance of User");
            $this->user = $user;
            $this->token = $token["token"];
            $this->id = $token["token_id"];
            $this->valid_until = $token["valid_until"];
            $this->deleted = false; //failsafe if token not removed properly
        }

        /**
         * Will remove the token from the database and remove it from the $user object
         * @return null
         */
        function delete() {
            $sql = "delete from phone_user_tokens where user_id=? and token=?";
            runIQuery($this->user->db, $sql, array("is", $this->user->id, $this->token));
            $this->deleted = true;

            if (($key = array_search($this, $this->user->tokens)) != false) unset($this->user->tokens[$key]);
        }

        /**
         * Refreshes the valid_until to 2 weeks from the current date
         *
         * Only applies if token expires in less than 12 days to avoid spamming the database transaction_log.
         * @return Token $this
         */
        function refresh() { //called whenever there is user activity
            global $dtformat;
            if (date($dtformat, strtotime("+12 day")) > $this->valid_until) {
                $sql = "update phone_user_tokens set valid_until=? where user_id=? and token=?";
                $newdate = date($dtformat, strtotime("+14 day"));
                runIQuery($this->user->db, $sql, array("sis", $newdate, $this->user->id, $this->token));

                $this->valid_until = $newdate;
            }

            return $this;
        }

        /**
         * Returns true if the token is still valid
         * @return boolean
         */
        function isValid() {
            global $dtformat;
            if (!$this->deleted && $this->valid_until > date($dtformat)) return true;
            else return false;
        }

        /**
         * Attempts to find token data for a given token string
         * @param UserManager $usermanager
         * @param string $token
         * @throws Exception "Token not found"
         * @return Token
         */
        public static function getFromTokenString($usermanager, $token) {
            $sql = "select * from phone_user_tokens where token=?";
            list($rs) = runIQuery($usermanager->db, $sql, array("s", $token));


            if (count($rs) == 0) throw new Exception("Token not found");

            try {
                $user = $usermanager->findUser($rs[0]["user_id"]);
                $token = new Token($rs[0], $user);
            } catch (Exception $err) {
                throw new Exception("Token not found");
            }

            return $token;
        }

        /**
         * Generates secure, pseudo random bytes as HEX characters
         * @return string
         */
        public static function generateRandomBytes() {
            $bytes = "";
            if (function_exists("openssl_random_pseudo_bytes")) $bytes = openssl_random_pseudo_bytes(40);
            else $bytes = random_bytes(40);

            return substr(bin2hex($bytes), 0, 40);
        }

        /**
         * Generates a new token for the given user
         * @param User $user
         * @throws Exception "Given value is not an instance of User"
         * @return Token
         */
        public static function generateToken($user) {
            global $dtformat;
            if (!($user instanceof User)) throw new Exception("Given value is not an instance of User");

            $token = Token::generateRandomBytes();

            $valid = date($dtformat, strtotime("+14 day"));

            $sql = "insert into phone_user_tokens (valid_until, user_id, token) values (?, ?, ?)";
            list($rs) = runIQuery($user->db, $sql, array("sis", $valid, $user->id, $token));

            return new Token(array(
                "token" => $token,
                "token_id" => $rs[0]["id"],
                "valid_until" => $valid
            ), $user);
        }

        /**
         * Gets all valid tokens of the given user
         * @param User $user
         * @throws Exception "Given value is not an instance of User"
         * @return array<int, Token>
         */
        public static function getValidTokens($user) {
            global $dtformat;
            if (!($user instanceof User)) throw new Exception("Given value is not an instance of User");

            $sql = "select * from phone_user_tokens where user_id=?";
            list($rs) = runIQuery($user->db, $sql, array("i", $user->id));

            if (!isset($user->tokens)) $user->tokens = array();

            array_splice($user->tokens, 0);

            if (count($rs)) {
                foreach ($rs as $token) {
                    $tkn = new Token($token, $user);
                    if (date($dtformat) > $tkn->valid_until) {
                        $tkn->delete();
                        continue;
                    }

                    array_push($user->tokens, $tkn); //add token
                }
            }

            return $user->tokens;
        }

        /**
         * Checks whether any given Token or token string is valid
         * @see Token::isValid()
         * @param mysqli $db
         * @param Token|string $token
         * @throws Exception "Token not found"
         * @return boolean
         */
        public static function tokenIsValid($db, $token) {
            global $dtformat;
            if ($token instanceof Token) return $token->isValid(); //redundant but useful

            $sql = "select * from phone_user_tokens where token=?";
            list($rs) = runIQuery($db, $sql, array(
                "s",
                $token
            ));

            if (count($rs) == 0) throw new Exception("Token not found");

            return $rs[0]["valid_until"] > date($dtformat);
        }
    }
?>