<?php
    //? TODO: think of how to make group chats?
    //? TODO: Delete messages (admins only? public function aka MessageHandler::deleteMessage ?)
    //? TODO: Create message prompts (admins only?)
    /**
     * Used to send and recieve messages
     * @author JoshuaA
     *
     */
    class MessageHandler {
        /**
         * The User that the message handler will send and recieve messages for
         * @var User
         */
        var $user;
        /**
         *
         * @param User $user
         * @return void
         */
        function __construct($user) {
            $this->user = $user;
        }

        /**
         * TODO
         */
        function deleteMessage() { //needed? limit to admins only? if user is admin can edit any, if not can only edit own?

        }

        /**
         * TODO
         */
        function editMessage($msgid, $newmsg) { //needed? limit to admins only? if user is admin can edit any, if not can only edit own?

        }

        /**
         * Sends a message to a given user
         * @param string $msg
         * @param User|int $r
         * @return array<string, string|int|null> [
         *     "message_id" => int,
         *     "message_text" => string,
         *     "sender_id" => int,
         *     "recipient_id" => int,
         *     "date_read" => string|null, (YYYY-MM-DD HH:MM:SS)
         *     "date_sent" => string (YYYY-MM-DD HH:MM:SS)
         * ]
         */
        function sendMessage($msg, $r) {
            global $dtformat;
            if (!($r instanceof User)) $r = $this->user->usermanager->findUser($r);

            $date = date($dtformat);
            $sql = "insert into phone_messages (message_text, sender_id, recipient_id, date_sent) values (?, ?, ?, ?)";
            list($rs,$err) = runIQuery($this->user->db, $sql, array(
                "siis",
                $msg,
                $this->user->id,
                $r->id,
                $date
            ));

            $last = $rs[0]["id"];
            if ($last == 0) throw new Exception($err);

            $sql = "delete from phone_messages_recent where (user1_id=? or user2_id=?) and (user1_id=? or user2_id=?)";
            runIQuery($this->user->db, $sql, array(
                "iiii",
                $this->user->id,
                $this->user->id,
                $r->id,
                $r->id
            ));

            $sql = "insert into phone_messages_recent (message_id, user1_id, user2_id) values (?, ?, ?);";
            runIQuery($this->user->db, $sql, array(
                "iii",
                $last,
                $this->user->id,
                $r->id
            ));

            return array(
                "message_id" => $last,
                "message_text" => $msg,
                "sender_id" => $this->user->id,
                "recipient_id" => $r->id,
                "date_read" => null,
                "date_sent" => $date
            );
        }


        /**
         * Gets all recent messages for the current user
         * @see MessageHandler::sendMessage()
         * @return array<int, array<string, string|int|null>>
         */
        function getRecentMessages() {
            $sql = "select * from phone_messages_recent inner join phone_messages on phone_messages.message_id=phone_messages_recent.message_id where user1_id=? or user2_id=?";
            list($rs) = runIQuery($this->user->db, $sql, array("ii", $this->user->id, $this->user->id));

            $messages = array();
            if (count($rs) != 0) {
                foreach ($rs as $message) {
                    $who = false;
                    if ($message["user1_id"] == $this->user->id) $who = $message["user2_id"];
                    else $who = $message["user1_id"];
                    $who = $this->user->usermanager->findUser($who);

                    array_push($messages, array(
                        "message_id" => $message["message_id"],
                        "message_text" => $message["message_text"],
                        "sender_id" => $message["sender_id"],
                        "recipient_id" => $message["recipient_id"],
                        "date_read" => $message["date_read"],
                        "date_sent" => $message["date_sent"]
                    ));
                }
            }

            return $messages;
        }


        /**
         * Gets all messages with a given user
         *
         * Optional: After a certain date
         * @param User $who
         * @param boolean $after (Optional)
         * @see MessageHandler::sendMessage()
         * @return array<int, array<string, string|int|null>>
         */
        function getMessagesWith($who, $before = false, $after = false) {
            global $dtformat;
            $sql = "select * from phone_messages where (sender_id=? or recipient_id=?) and (sender_id=? or recipient_id=?)";
            $vars = array("iiii", $who, $who, $this->user->id, $this->user->id);

            if ($before != false) {
                if (strlen($before) == 10) $before .= "T01:00:01";
                $sql .= " and date_sent < '$before'";
            }

            if ($after != false) {
                if (strlen($after) == 10) $after .= "T01:00:01";
                $sql .= " and date_sent > '$after'";
            }

            $sql .= " order by date_sent desc";

            list($rs) = runIQuery($this->user->db, $sql, $vars);
            $who = $this->user->usermanager->findUser($who);


            $messages = array();
            if (count($rs) != 0) {
                foreach ($rs as $message) {
                    if ($message["sender_id"] == $who->id && empty($message["date_read"])) {
                        $sql = "update phone_messages set date_read=NOW() where message_id=" . $message["message_id"];
                        $message["date_read"] = date($dtformat);
                        runIQuery($this->user->db, $sql);
                    }
                    array_push($messages, array(
                        "message_id" => $message["message_id"],
                        "message_text" => $message["message_text"],
                        "sender_id" => $message["sender_id"],
                        "recipient_id" => $message["recipient_id"],
                        "date_read" => $message["date_read"],
                        "date_sent" => $message["date_sent"]
                    ));
                }
            }

            return $messages;
        }

        /**
         * Gets all available message prompts for the current users job
         * @return array<int, array<string, string|int>> [
         *     [
         *         "prompt_id" => int,
         *         "message_text" => string,
         *         "job_id" => int
         *     ]
         * ]
         */
        function getPrompts() {
            $sql = "select * from phone_message_prompts"; //0 is for everyone
            list($rs) = runIQuery($this->user->db, $sql);

            return stripResults($rs);
        }

        //*Needs the prompt and which job it's for (defaults to 0, aka all jobs)
        //*insert into phone_message_prompts (message_text, job_id) values (?, ?)
        /**
         * TODO
         */
        public static function createMessagePrompt() {

        }
    }
?>