<?php
    date_default_timezone_set("America/Detroit");
    ini_set('display_errors', 'On');
    $dtformat = "Y-m-d H:i:s";
    $dformat = "Y-m-d";
    $debug = true;
    require __DIR__ . "/libs/PTORequest.php"; //!also gets runIQuery.php, User.php and Token.php

    $method = $_SERVER["REQUEST_METHOD"];
    if ($method == "GET") $params = $_GET;
    else if ($method == "POST") {
        $params = $_POST;

        if (preg_match_all("/token=([^&]+)/", $_SERVER["QUERY_STRING"], $matches)) {
            $params["token"] = $matches[1][0];
        }
    } else if ($method == "PUT") {
        $_PUT = json_decode(file_get_contents("php://input"), true);
        $_REQUEST = array_merge($_REQUEST, $_PUT);
        $params = $_PUT;
        if (preg_match_all("/token=([^&]+)/", $_SERVER["QUERY_STRING"], $matches)) {
            $params["token"] = $matches[1][0];
        }
    }
    $params["url"] = $_GET["url"];

    try {
        $json = file_get_contents("php://input");
        if (!empty($json)) {
            $data = (array) json_decode($json);
            $params = array_merge($params, $data);
        }
    } catch (Exception $err) {

    }

    $resp = array("success" => false);



    function finish() {
        global $resp;
        global $params;
        global $debug;
        global $method;

        echo json_encode($resp);
        die();
    }
    //!use 'finish();' when you don't want the code to go further and you want to send a response
    //!to reduce lines of code you can also do finish($resp["message"] = "Invalid Token"); or similar

    function send501() {
        global $resp;
        http_response_code(501);
        finish($resp["message"] = "501 Not Implemented");
    }

    function send404() {
        http_response_code(404);
        die();
    }

    function send403() {
        global $resp;
        http_response_code(403);
        if (empty($resp["message"])) $resp["message"] = "Missing or Invalid Token";
        finish();
    }

    header("Access-Control-Allow-Origin: *");
    if ($method == "OPTIONS") {
        header("Access-Control-Max-Age: 1200");
        header("Access-Control-Allow-Methods: GET,POST,OPTIONS,DELETE,PUT");
        header("Access-Control-Allow-Headers: DNT,Keep-Alive,User-Agent,X-Requested-With,Content-Type,Content-Length,Authorization,If-Modified-Since,X-CustomHeader,Cache-Control");
        die();
    }

    header("Content-Type: application/json; charset=utf-8");

    if (!isset($params)) send501();

    if (!isset($params["url"])) $params["url"] = "index";
    $dirs = explode("/", $params["url"]);
    $base = $dirs[0];
    $subdir = false;
    if (!empty($dirs[1])) $subdir = $dirs[1];
    $deep = false;
    if (!empty($dirs[2])) $deep = $dirs[2]; //will be used if we implement group chats
    //url example: /profiles/1
    //base = profile, subdir = 1, deep = false

    $uManager = new UserManager($db, $edb);

    $authorized = false;
    if (isset($params["token"])) {
        try {
            $token = Token::getFromTokenString($uManager, $params["token"]);
            $user = $token->user;
            $_SESSION["influxuser"] = $user->email; //*Since we can't use sessions due to the way the app will work
            $authorized = $token->isValid();
        } catch (Exception $err) { }
    }

    $page = __DIR__ . "/public_pages/" . $base . ".php";
    if (file_exists($page)) {
        $sql="SET time_zone = '" .date('P') . "'";
        runIQuery($db, $sql);
        require($page); //load page if it exists, if not, send 404
    } else send404();

    if ($resp["success"] == false && !isset($resp["message"])) send501(); //!if response not modified it means they sent the wrong type of request and thus, 501
    else finish();
?>