<?php
$expanded=1;
$locked=0;
include('dbConnection.php');
## session start is now in dbconnection.php;
include('security.php');
include('functions.php');
include('header.php');
print renderPanel("Allocation Report","","green","span11","cogs");
// get list of items

$sql="select item_name, item_description from items order by item_name ";
$rs=mysqli_query($db,$sql);
$partPrefix=strtoupper($_GET['part_prefix']);
$customer=$_GET['customer'];
$just=$_GET['just'];
$start_date=$_GET['start_date'];
print "<form action='allocationSummaryReport.php' name='findform' method='GET'>";

$items=array();
while ($data=mysqli_fetch_array($rs)) {
	$items[]=$data['item_name'];
}
$itemcount=count($itemlist);
print renderTextList("part_prefix","$partPrefix","Part Prefix",$items);

// add inactive customers code -Josh 02/20/2023
$sql = "select customer_id, name from customers where inactive_customer=0 OR (customer_id=? and inactive_customer=1) order by name";
list($rs,$err)=runIQuery($db,$sql,["i",$customer]);
print renderSelect(TRUE,"customer",$customer,"Customer","N",$rs,1);
print renderOptions($rs,$group);
print renderCheckBox(TRUE,"just",$just,"Just this Part?");
print renderDateBox(TRUE,"start_date",$start_date,"Everything After This Date Entered");
print "</form>\n";
print renderButton("Find","green","document.findform.submit();");
print "&nbsp;";
print renderButton("Detail","yellow","document.findform.action='allocationReport.php';document.findform.submit();");
print "&nbsp;";
print renderButton("Export","blue","exportReport();");
print "<div class='clear'></div>\n";
print "<div class='span11'>";
## calculations are all done here
print "<table class=' table-striped table-bordered table-condensed flip-content'>";
print "<thead>";
print "<tr style='width: 100%'>";
print "<th valign='top'>";
print "Part";
print "</th>";
print "<th valign='top'>";
print "Description";
print "</th>";
print "<th valign='top' align='right'>";
print "Quantity Needed";
print "</th>";
print "</tr>\n";
print "</thead>\n";
print "<tbody>\n";
$vendorlist=array();
$itemvendor=array();
$itemlist=array();
$qtylist=array();
$processlist=array();
$sd=formatDateWebtoDB($start_date);
$sql="select item_id, quantity, coalesce(shipped_quantity,0) as shipped, o.order_id from orders o, order_lines l where o.order_id=l.order_id and o.date_order >= '$sd' and item_id like '$partPrefix%' and o.status = 1 ";
if ($customer){
	$sql.=" and customer_id=$customer ";
}
$sql.=" order by item_id ";
list($rs,$err)=runIQuery($db,$sql);
foreach ($rs as $data) {
	$item=$data['item_id'];
	$qty=$data['quantity'] - $data['shipped'];
	if (in_array($item,$itemlist)) {
		$qtylist[$item] += $qty;
	} else {
		$itemlist[]=$data['item_id'];
		$qtylist[$item]=$qty;
	}
}

$fnd=1;
while ($fnd > 0) {
	set_time_limit(100);
	reset($itemlist);
	foreach ($itemlist as $itemMaster) {
		$fnd=0;
		if (! in_array($itemMaster,$processlist)) {
			$fnd=1;
			$processlist[]=$itemMaster;
			$sql="select child_item, quantity_per from billofmaterial where parent_item=?";
			list($rs,$err)=runIQuery($db,$sql,array("s",$itemMaster));
			foreach ($rs as $data) {
				$qtyper=$data['quantity_per'];
				$child=$data['child_item'];
				if (! in_array($child,$itemlist)) {
					$itemlist[]=$child;
					$qtylist[$child]=$qtyper * $qtylist[$itemMaster];
				} else {
					$qtylist[$child]+=$qtyper * $qtylist[$itemMaster];
				}
			}
		}
	}
}
reset($itemlist);
foreach ($itemlist as $itemMaster) {
	$sql="select vendor_name from items, vendors where item_name=? and items.vendor_id=vendors.vendor_id";
	list($rs,$err)=runIQuery($db,$sql,array("s",$itemMaster));
	foreach ($rs as $data) {
		$vid=$data['vendor_name'];
		if (! in_array($vid,$vendorlist)) {
			$vendorlist[]=$vid;
		}
		$itemvendor[$itemMaster]=$vid;
	}
}
reset($vendorlist);
sort($vendorlist);
sort($itemlist);
foreach($vendorlist as $vendor) {
	reset($itemlist);
	$vnd=str_replace(" ","",$vendor);
	$vnd=str_replace(",","",$vnd);
	$vnd=str_replace(".","",$vnd);
	print "<tr><td colspan='3' align='center'>$vendor</td><td><div class='btn green' onclick=\"createPO('$vnd','$vendor');\"><b><i class='icon-plus'>&nbsp;</i></b> Create PO</div></td></tr>";
	$i=0;
	foreach ($itemlist as $itemMaster) {
		if ($itemvendor[$itemMaster]==$vendor) {
			print "<tr><td>";
			$i++;
			print "<input type='hidden' id='item$vnd-$i' value='$itemMaster'>";
			print "$itemMaster</td>";
			$sql="select item_description from items where item_name=?";
			list($rs,$err)=runIQuery($db,$sql,array("s",$itemMaster));
			print "<td>";
			print $rs[0][0];
			print "</td>";
			print "<td align='right'>";
			print "<input type='hidden' id='qty$vnd-$i' value='" . $qtylist[$itemMaster] . "'>";
			print number_format($qtylist[$itemMaster],0);
			print "</td>";
			print "<td align='center'>";
			print "<input type='checkbox' id='chk$vnd-$i' checked>";
			print "</td>";
			print "</tr>";
		}
	}
	print "<tr><td>";
	print "<input type='hidden' id='itemcount$vnd' value='$i'>";
	print "</td></tr>";
}
reset($itemlist);
print "<tr><td colspan='3' align='center'>No Vendor</td></tr>";
foreach ($itemlist as $itemMaster) {
	if ($itemvendor[$itemMaster]=="") {
		print "<tr><td>$itemMaster</td>";
		$sql="select item_description from items where item_name=?";
		list($rs,$err)=runIQuery($db,$sql,array("s",$itemMaster));
		print "<td>";
		print $rs[0][0];
		print "</td>";
		print "<td align='right'>";
		print number_format($qtylist[$itemMaster],0);
		print "</td>";
		print "</tr>";
	}
}

print "</tbody>\n";
print "</table>";
print renderClosePanel();
?>
<script>
	function exportReport() {
		if ('<?=$partPrefix?>' != '') {
			window.open('allocationSummaryReportExport.php?part_prefix=<?=$partPrefix?>&start_date=<?=$start_date?>','exporter');
		}
	}
	function createPO(vnd,vendor) {
		cntr = $('#itemcount'+vnd).val();
		formdata='vendor='+vendor;
		parts='';
		qtys='';
		var comma='';
		for (i=1; i <= cntr; i++ ) {
			if (document.getElementById('chk'+vnd + '-' +i).checked) {
				parts=parts + comma;
				qtys = qtys + comma;
				parts = parts + $('#item'+vnd + '-' +i).val();
				qtys = qtys + $('#qty'+vnd + '-' +i).val();
				comma=',';
			}
		}
		formdata=formdata + '&parts=' + parts;
		formdata=formdata + '&qtys=' + qtys;
		url='createPO.php';
		$.ajax({
			type: "POST",
			url: url,
			data: formdata, // serializes the form's elements.
			success: function(data)
			{
				window.open('editPO.php?id='+data,'newpo'+data);
			}
		});


	}
</script>
<?php
include('footer.php');
?>